package fr.cnam.myrmi;

import java.util.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;

public class MyRMIServerSocket implements Runnable
{
  private Hashtable<Integer,ServerSocket> ssocs = new Hashtable<Integer,ServerSocket>();
    private ArrayList<MyRemoteObject> skeltons;
    private ServerSocket ssoc;
    private static MyRMIServerSocket myssoc = null;

    static public MyRMIServerSocket getInstance(int port)
    {
        if (myssoc==null)
            {
                myssoc = new MyRMIServerSocket(port);
                return myssoc;
            }
        else
            return myssoc;
    }

    private  MyRMIServerSocket(int port)
    {
        try{
            skeltons = new ArrayList<MyRemoteObject>();
            ssoc     = new ServerSocket(port);
            Thread t = new Thread(this);
            t.start();
        }catch(Exception ex)
            {
                System.out.println("Erreur dans MyRMIServerSocket");
                System.out.println(ex);
                ex.printStackTrace();
            }
    }

    synchronized public void addRemoteObject(MyRemoteObject sk)
    {
        System.out.println("Ajout d'un skelton: "+sk.getObjId().getHashCode());
        skeltons.add(sk);
    }

    public void run()
    {
        try{
            while (true)
                {
                    Socket soc = ssoc.accept();
                    OutputStream os=soc.getOutputStream();
                    ObjectOutputStream oos=new ObjectOutputStream(os);
                    InputStream is=soc.getInputStream();
                    ObjectInputStream ois=new ObjectInputStream(is);

                    Integer hashCodeRemote = (Integer)(ois.readObject());
                    String methode = (String)(ois.readObject());

                    MyRemoteObject skelton = null;
                    for(MyRemoteObject sk : skeltons)
                      if (sk.getObjId().getHashCode() == hashCodeRemote.intValue())
                            skelton = sk;
                    
                    if(skelton!=null)
                        {
                            System.out.println(">>invoke de "+methode);
                            
                            Integer onbarg = (Integer)(ois.readObject());
                            int nbarg = onbarg.intValue();
                            if (nbarg!=0)
                                {
                                    Object[] args = (Object[])(ois.readObject());
                                    Class<?>[] classes = new Class<?>[args.length];
                                    int i=0;
                                    for(Object o:args) classes[i++]=o.getClass();
                                    
                                    Method m = skelton.getClass().getMethod(methode,classes);
                                    Object rep = m.invoke(skelton,args);
                                    if (rep==null)
                                        oos.writeObject(new Integer(0));
                                    else
                                        oos.writeObject(rep);
                                }
                            else
                                {
                                    Method m = skelton.getClass().getMethod(methode);
                                    Object rep = m.invoke(skelton);
                                    if (rep==null)
                                        oos.writeObject(new Integer(0));
                                    else
                                        oos.writeObject(rep);
                                }
                        }
                    else
                        {
                            System.out.println("ERREUR: skelton non trouve: "+hashCodeRemote.intValue());
                        }
                }
        }catch(Exception ex)
            {
                System.out.println("Erreur dans MyRMIServerSocket : run");
                System.out.println(ex);
                ex.printStackTrace();
            }
    }
}